/**
 * 
 */
package gov.va.med.mhv.sm.admin.enums;


public enum ActivityEnum {

	OPT_IN (0L, "OPT-IN"),
	OPT_OUT (1L, "OPT-OUT"),
	MESSAGE_SENT (2L, "MESSAGE SENT"),
	SURROGATE_SENT (3L, "SURROGATE SENT"),
	MESSAGE_READ(4L, "MESSAGE READ"),
	MESSAGE_ASSIGNED(5L, "MESSAGE ASSIGNED"),
	PROGRESS_NOTE(6L, "PROGRESS NOTE"),
	MESSAGE_COMPLETED (7L, "MESSAGE COMPLETED"),
	MESSAGE_ARCHIVED (8L, "MESSAGE ARCHIVED"),
	PATIENT_BLOCKED (9L, "PATIENT BLOCKED"),
	PATIENT_UNBLOCKED (10L, "PATIENT UNBLOCKED"),
	NOTIFICATION_PREFERENCES_CHANGE(11L,"NOTIFICATION PREFERENCES CHANGE"),
	CLINICIAN_INBOXVIEW(12L,"CLINICIAN_INBOXVIEW"),
	SURROGATE_SETUP(13L,"SURROGATE_SETUP"),
	USER_SIGNATURE(14L,"USER SIGNATURE"),
	COMPLETED_MESSAGE_REASSIGNMENT(15L, "COMPLETED MESSAGE REASSIGNMENT"),
	USERINFO_CHANGED(16L,"USERINFO CHANGED"),
	RECALLED_MESSAGE(17L,"RECALLED MESSAGE"),
	MESSAGE_READ_BY_ADMIN(18L,"MESSAGE READ BY ADMIN"),
	ACTION_PENDING_PATIENT(19L,"NOT OPTED IN"), // Patient Click SM button but not Opted In/Opted out yet.
	NEW_MESSAGE_EMAIL_NOTIFICATION(20L,"NEW MESSAGE EMAIL NOTIFICATION"),
	REASSIGN_MESSAGE_EMAIL_NOTIFICATION(21L,"REASSIGN EMAIL NOTIFICATION"),
	MESSAGE_SENT_ERROR(22L,"MESSAGE SENT ERROR"),
	FACILITY_ADMIN_EMAIL_NOTIFICATION(23L,"FACILITY ADMIN EMAIL NOTIFICATION");
	
	private Long id;
	private String name;
	
	private ActivityEnum(Long id, String name){
		this.id = id;
		this.name = name;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static ActivityEnum valueOf(Long value){
		for(ActivityEnum f : ActivityEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no enum found");
	}
	
	
	
}
